<?php

namespace App\Http\Controllers\API;

use App\Article;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\OfferPrice;
use App\Setting;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class ArticlesController extends Controller
{
    public function articles(Request $request, $lang = 'en')
    {
        header('Access-Control-Allow-Origin: *');

        if ($request->type_id != null) {
            $articles  = Article::where('type', $request->type_id)->select('id', 'title_' . $lang . ' AS title', 'short_desc_' . $lang . ' AS short_desc', 'photo', 'article_date', 'slug_' . $lang . ' AS slug')->orderBy('article_date', 'desc')->paginate(9);
        } elseif ($request->hashtag != null) {
            $articles  = Article::where('hashtags_' . $lang, 'like', "%{$request->hashtag}%")->select('id', 'title_' . $lang . ' AS title', 'short_desc_' . $lang . ' AS short_desc', 'photo', 'article_date', 'slug_' . $lang . ' AS slug')->orderBy('article_date', 'desc')->paginate(9);
        } else {
            $articles  = Article::select('id', 'title_' . $lang . ' AS title', 'short_desc_' . $lang . ' AS short_desc', 'photo', 'article_date', 'slug_' . $lang . ' AS slug')->orderBy('article_date', 'desc')->paginate(9);
        }
        if (sizeof($articles) > 0) {
            $data['success'] = true;
            $data['articles'] = $articles;
        } else {
            $data['success'] = true;
            $data['empty'] = true;
        }

        return response()->json($data, 200);
    }

    public function articlesView(Request $request, $lang = 'en')
    {
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: GET, POST');

        if ($request->type_id != null) {
            $articles  = Article::where('type', $request->type_id)->select('id', 'title_' . $lang . ' AS title', 'short_desc_' . $lang . ' AS short_desc', 'photo', 'article_date', 'slug_' . $lang . ' AS slug')->orderBy('article_date', 'desc')->paginate(9);
        } elseif ($request->hashtag != null) {
            $articles  = Article::where('hashtags_' . $lang, 'like', "%{$request->hashtag}%")->select('id', 'title_' . $lang . ' AS title', 'short_desc_' . $lang . ' AS short_desc', 'photo', 'article_date', 'slug_' . $lang . ' AS slug')->orderBy('article_date', 'desc')->paginate(9);
        } else {
            $articles  = Article::select('id', 'title_' . $lang . ' AS title', 'short_desc_' . $lang . ' AS short_desc', 'photo', 'article_date', 'slug_' . $lang . ' AS slug')->orderBy('article_date', 'desc')->paginate(9);
        }
        if (sizeof($articles) > 0) {
            $data['success'] = true;
            $data['articles'] = $articles;
        } else {
            $data['success'] = true;
            $data['empty'] = true;
        }

        return response()->json($data, 200);
    }


    public function featuredAricles($lang = 'ar')
    {
        header('Access-Control-Allow-Origin: *');
        $articles = Article::select('id', 'title_' . $lang . ' AS title', 'short_desc_' . $lang . ' AS short_desc', 'photo', 'article_date', 'slug_' . $lang . ' AS slug')->where('featured', '=', true)->orderBy('article_date', 'desc')->take(3)->get();
        if (sizeof($articles) > 0) {
            $data['data'] = ['success' => true, 'articles' => $articles];
        } else {
            $data['data'] = ['success' => true, 'empty' => true];
        }

        return response()->json($data, 200);
    }

    public function ViewAricle($lang = 'ar', $slug = 1)
    {
        header('Access-Control-Allow-Origin: *');
        $article = Article::select('id', 'title_' . $lang . ' AS title', 'desc_' . $lang . ' AS desc', 'photo', 'article_date', 'hashtags_' . $lang . ' AS hashtags', 'type', 'slug_' . $lang . ' AS slug')->where('slug_ar', $slug)->orWhere('slug_en', $slug)->first();
        $data['data'] = ['success' => true, 'article' => $article];
        return response()->json($data, 200);
    }

    public function semilarAricle($lang = 'ar', $type = 1)
    {

        header('Access-Control-Allow-Origin: *');
        $articles = Article::select('id', 'title_' . $lang  . ' AS title', 'short_desc_' . $lang . ' AS short_desc', 'photo', 'article_date', 'type', 'slug_' . $lang . ' AS slug')->where('type', '=', $type)->orderBy('article_date', 'desc')->take(3)->get();
        if (sizeof($articles) > 0) {
            $data['data'] = ['success' => true, 'articles' => $articles];
        } else {
            $data['data'] = ['success' => true, 'empty' => true];
        }

        return response()->json($data, 200);
    }

    public function sendOfferPrice(Request $request)
    {
        // print_r($request);
        header('Access-Control-Allow-Origin: *');
        $validator = Validator::make($request->all(), [
            'name'              => 'required',
            'type_of_work'      => 'required',
            'phone'             => 'required',
        ]);

        if ($validator->fails()) {
            $data['success'] = false;
            $data['errors'] = $validator->errors();
            return response()->json($data);
        }

        $saveOfferPrice  = OfferPrice::create([
            'name' => $request->name,
            'type_of_work' => $request->type_of_work,
            'phone' => $request->phone,
            'email' => $request->email,
            'pagename' => $request->pagename
        ]);
        $this->myRequest = $request->all();
        $this->ElrasheedMail = Setting::where('id', 1)->first();
        $data = array('name' =>  $this->myRequest['name'], "content" => $this->myRequest['pagename'], "email" => $this->myRequest['email'],'typeOfWork' =>  $this->myRequest['type_of_work'], 'phone' =>  $this->myRequest['phone']);

        $this->Subject = 'Request a trial version';
        Mail::send('admin.mailRequestForm', $data, function ($message) {
            $message->from($this->myRequest['email'], $this->myRequest['name']);
            $message->to($this->ElrasheedMail->rasheed_email, $this->Subject);
            // $message->cc(['tatya@emarketing-egypt.com', 'hager@emarketing-egypt.com', 'Christine@emarketing-egypt.com']);
            $message->cc(['a.emam@semicolon-ltd.com']);
            $message->subject($this->Subject);
        });
        $data['data'] = ['success' => true];
        return response()->json($data, 200);
    }
}
