<?php

namespace App\Http\Controllers\API;

use App\Client;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ClientsController extends Controller
{
    public function getClients($lang = 'ar')
    {
        header('Access-Control-Allow-Origin: *');
        $clients = Client::select('id', 'name_' . $lang . ' AS name', 'photo')->orderBy('created_at', 'desc')->offset(0)->limit(100)->get();
        if (sizeof($clients) > 0) {
            $data['data'] = ['success' => true, 'clients' => $clients];
        } else {
            $data['data'] = ['success' => true, 'empty' => true];
        }

        return response()->json($data, 200);
    }
}
