<?php

namespace App\Http\Controllers\API;

use App\Article;
use App\Client;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Comment;
use App\OurProgram;
use App\OurProgramSlider;
use App\ProjectPhoto;
use App\Setting;
use App\Team;
use App\Technology;
use Illuminate\Support\Facades\Mail;

class CommentsController extends Controller
{
    public function getClientComments()
    {
        header('Access-Control-Allow-Origin: *');
        $comments = Comment::select('id', 'name', 'position', 'photo', 'comment')->orderBy('created_at', 'desc')->get();
        if (sizeof($comments) > 0) {
            $data['data'] = ['success' => true, 'comments' => $comments];
        } else {
            $data['data'] = ['success' => true, 'empty' => true];
        }

        return response()->json($data, 200);
    }

    public function mainVedioLink()
    {
        header('Access-Control-Allow-Origin: *');
        $link = Setting::select('main_vedio_link')->find(1);
        $data['data'] = ['success' => true, 'link' => $link];
        return response()->json($data, 200);
    }

    public function footerData($lang = 'ar')
    {
        header('Access-Control-Allow-Origin: *');
        if ($lang == 'ar') {
            $lang = 'ara';
        } else {
            $lang = 'eng';
        }
        $footerData = Setting::select('address_' . $lang . ' AS adress', 'rasheed_email AS email', 'rasheed_telephon AS land_line', 'phone', 'phone_whatsapp', 'fax', 'facebook', 'twitter', 'linked_in', 'location')->find(1);
        $client  = @$_SERVER['HTTP_CLIENT_IP'];
        $forward = @$_SERVER['HTTP_X_FORWARDED_FOR'];
        $remote  = @$_SERVER['REMOTE_ADDR'];
        $result  = array('country' => '', 'city' => '');
        if (filter_var($client, FILTER_VALIDATE_IP)) {
            $ip = $client;
        } elseif (filter_var($forward, FILTER_VALIDATE_IP)) {
            $ip = $forward;
        } else {
            $ip = $remote;
        }
        $ip_data = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . $ip));
        if ($ip_data && $ip_data->geoplugin_countryName != null) {
            $countryCode = $ip_data->geoplugin_countryCode;
        } else {
            $countryCode = 'EG';
        }
        $data['data'] = ['success' => true, 'footerData' => $footerData, 'countryCode' => $countryCode];
        return response()->json($data, 200);
    }

    public function MainDescriptionErpDescription($lang = 'ar')
    {
        header('Access-Control-Allow-Origin: *');
        $MainDescriptionErpDescription = Setting::select('home_title_' . $lang . ' AS home_title', 'home_description_' . $lang . ' AS home_description', 'erp_title_' . $lang . ' AS erp_title', 'erp_description_' . $lang . ' AS erp_description')->find(1);
        $data = ['success' => true, 'data' => $MainDescriptionErpDescription];
        return response()->json($data, 200);
    }

    public function goalCards($lang = 'ar')
    {
        header('Access-Control-Allow-Origin: *');
        $goalCards = Setting::select('cart_1_icon', 'cart_1_title_' . $lang . ' AS cart_1_title', 'cart_1_description_' . $lang . ' AS cart_1_description', 'cart_2_icon', 'cart_2_title_' . $lang . ' AS cart_2_title', 'cart_2_description_' . $lang . ' AS cart_2_description', 'cart_3_icon', 'cart_3_title_' . $lang . ' AS cart_3_title', 'cart_3_description_' . $lang . ' AS cart_3_description', 'cart_4_icon', 'cart_4_title_' . $lang . ' AS cart_4_title', 'cart_4_description_' . $lang . ' AS cart_4_description')->find(1);
        $cart[0]['photo'] = $goalCards->cart_1_icon;
        $cart[0]['title'] = $goalCards->cart_1_title;
        $cart[0]['description'] = $goalCards->cart_1_description;

        $cart[1]['photo'] = $goalCards->cart_2_icon;
        $cart[1]['title'] = $goalCards->cart_2_title;
        $cart[1]['description'] = $goalCards->cart_2_description;

        $cart[2]['photo'] = $goalCards->cart_3_icon;
        $cart[2]['title'] = $goalCards->cart_3_title;
        $cart[2]['description'] = $goalCards->cart_3_description;

        $cart[3]['photo'] = $goalCards->cart_4_icon;
        $cart[3]['title'] = $goalCards->cart_4_title;
        $cart[3]['description'] = $goalCards->cart_4_description;

        $data = ['success' => true, 'data' => $cart];
        return response()->json($data, 200);
    }

    public function aboutUsText($lang = 'ar')
    {
        header('Access-Control-Allow-Origin: *');
        $aboutUsText = Setting::select('about_us_description_' . $lang . ' AS about_us_description')->find(1);
        $data = ['success' => true, 'data' => $aboutUsText];
        return response()->json($data, 200);
    }

    public function technologies($type, $lang = 'ar')
    {
        header('Access-Control-Allow-Origin: *');
        $technologies = Technology::where('type', $type)->select('icon', 'name_' . $lang . ' AS name')->get();
        $data = ['success' => true, 'data' => $technologies];
        return response()->json($data, 200);
    }
    public function counterData()
    {
        header('Access-Control-Allow-Origin: *');
        $counterData = Setting::select('yeers_of_exprience', 'employees', 'clients', 'products AS projects', 'partners')->find(1);
        $data['data'] = ['success' => true, 'counterData' => $counterData];
        return response()->json($data, 200);
    }

    public function loopImagesChangeExtensions()
    {
        header('Access-Control-Allow-Origin: *');
        $images = Team::select('id', 'photo')->get();
        foreach ($images as $key => $value) {
            $name = explode('.', $value->photo);
            $oneImage = Team::find($value->id);
            if ($name[1] == 'png' || $name[1] == 'jpg' || $name[1] == 'jpeg') {
                $oneImage->photo = $name[0] . '.webp';
                // return response()->json($oneImage, 200);
                $oneImage->save();
            }
        }
        return response()->json($images, 200);
    }

    // public function loopImagesChangeExtensions()
    // {
    //     header('Access-Control-Allow-Origin: *');
    //     $images = OurProgramModule::select('id', 'icon_o','icon_w')->get();
    //     foreach ($images as $key => $value) {
    //         $name1 = explode('.', $value->icon_o);
    //         $name2 = explode('.', $value->icon_w);
    //         $oneImage = OurProgramModule::find($value->id);
    //         if ($name1[1] == 'png' || $name1[1] == 'jpg' || $name1[1] == 'jpeg') {
    //             $oneImage->icon_o = $name1[0] . '.webp';
    //             // return response()->json($oneImage, 200);
    //             $oneImage->save();
    //         }

    //         if ($name2[1] == 'png' || $name2[1] == 'jpg' || $name2[1] == 'jpeg') {
    //             $oneImage->icon_w = $name2[0] . '.webp';
    //             // return response()->json($oneImage, 200);
    //             $oneImage->save();
    //         }
    //     }
    //     return response()->json($images, 200);
    // }

    public function sendMail(Request $request)
    {
        // 
        header('Access-Control-Allow-Origin: *');
        $this->myRequest = $request->all();
        $this->ElrasheedMail = Setting::where('id', 1)->first();
        $data = array('name' =>  $this->myRequest['name'], "content" => $this->myRequest['content'], "email" => $this->myRequest['email'], 'phone' =>  $this->myRequest['phone'], 'subject' => $this->myRequest['subject']);
        $data3 = array('name' =>  'Semicolon-ltd', "content" => 'Your E-mail to semicolon sent successfully thank you for your trust :)', "email" => $this->ElrasheedMail->rasheed_email, 'phone' =>  $this->myRequest['phone'], 'subject' => 'Your E-mail to semicolon sent successfully thank you for your trust :)');

        $this->Subject = $this->myRequest['subject'] . 'From ContactUs Form';

        Mail::send('admin.mailForm', $data, function ($message) {
            $message->from($this->myRequest['email'], $this->myRequest['name']);
            $message->to($this->ElrasheedMail->rasheed_email, $this->Subject);
            // $message->cc(['tatya@emarketing-egypt.com','hager@emarketing-egypt.com','Christine@emarketing-egypt.com']);
            $message->cc(['a.emam@semicolon-ltd.com']);
            $message->subject($this->Subject);
        });

        Mail::send('admin.mailForm', $data3, function ($message) {
            $message->from($this->ElrasheedMail->rasheed_email, $this->myRequest['name']);
            $message->to($this->myRequest['email'], 'Your E-mail to semicolon sent successfully thank you for your trust :)');
            $message->subject('Your E-mail to semicolon sent successfully thank you for your trust :)');
        });

        $data2['data'] = ['success' => true];
        return response()->json($data2, 200);
    }
}
