<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\OurProgram;

class OurProgramController extends Controller
{
    public function ourProgramsSlider($lang)
    {
        header('Access-Control-Allow-Origin: *');
        $OurPrograms = OurProgram::select('id', 'title_' . $lang . ' AS title', 'icon', 'slug_' . $lang . ' AS slug')->orderBy('periority', 'asc')->get();
        if (sizeof($OurPrograms) > 0) {
            $data['data'] = ['success' => true, 'OurPrograms' => $OurPrograms];
        } else {
            $data['data'] = ['success' => true, 'empty' => true];
        }

        return response()->json($data, 200);
    }

    public function ourProgramsPage($lang)
    {
        header('Access-Control-Allow-Origin: *');
        $OurPrograms = OurProgram::select('id', 'title_' . $lang . ' AS title', 'description_' . $lang . ' AS description', 'photo', 'slug_' . $lang . ' AS slug')->orderBy('periority', 'asc')->get();
        if (sizeof($OurPrograms) > 0) {
            $data['data'] = ['success' => true, 'OurPrograms' => $OurPrograms];
        } else {
            $data['data'] = ['success' => true, 'empty' => true];
        }

        return response()->json($data, 200);
    }

    public function programDetails($slug, $lang)
    {
        header('Access-Control-Allow-Origin: *');
        $this->lang = $lang;
        $OurProgram = OurProgram::with(['OurProgramSlider' => function ($ups) {
            $ups->select('id', 'our_program_id', 'title_' . $this->lang . ' AS title', 'description_' . $this->lang . ' AS description', 'photo')->orderBy('periority', 'ASC');
        }, 'OurProgramModule' => function ($opm) {
            $opm->select('id', 'our_program_id', 'title_' . $this->lang . ' AS title', 'description_' . $this->lang . ' AS description', 'icon_w', 'icon_o')->orderBy('periority', 'ASC');
        }, 'OurProgramFeature' => function ($opf) {
            $opf->select('id', 'our_program_id', 'title_' . $this->lang . ' AS title', 'icon_w', 'icon_o')->orderBy('periority', 'ASC');
        }, 'OurProgramAccordion' => function ($opa) {
            $opa->select('id', 'our_program_id', 'title_' . $this->lang . ' AS title', 'description_' . $this->lang . ' AS description')->orderBy('periority', 'ASC');
        }, 'articles' => function ($article) {
            $article->select('articles.id', 'articles.title_' . $this->lang  . ' AS title', 'articles.short_desc_' . $this->lang . ' AS short_desc', 'articles.photo', 'articles.article_date', 'articles.type', 'articles.slug_' . $this->lang . ' AS slug')->orderBy('articles.article_date', 'desc');
        }])->select('id', 'title_' . $lang . ' AS title', 'description_' . $lang . ' AS description', 'photo', 'icon', 'periority', 'demo_link', 'slug_' . $lang . ' AS slug')->where('slug_ar', $slug)->orWhere('slug_en', $slug)->first();
        $data['data'] = ['success' => true, 'OurProgram' => $OurProgram];
        return response()->json($data, 200);
    }

    public function programRelatedArticles($slug, $lang)
    {
        header('Access-Control-Allow-Origin: *');
        $this->lang = $lang;
        $OurProgram = OurProgram::select('id', 'title_' . $lang . ' AS title', 'description_' . $lang . ' AS description', 'photo', 'icon', 'periority', 'demo_link', 'slug_' . $lang . ' AS slug')->where('slug_ar', $slug)->orWhere('slug_en', $slug)->first();
        $articles = $OurProgram->articles()->orderBy('articles.article_date', 'desc')->paginate(9);
        foreach ($articles as $key => $value) {
            $articles[$key]['title'] = $value['title_' . $this->lang];
            $articles[$key]['short_desc'] = $value['short_desc_' . $this->lang];
            $articles[$key]['slug'] = $value['slug_' . $this->lang];
            unset(
                $articles[$key]['featured'],
                $articles[$key]['hashtags_ar'],
                $articles[$key]['hashtags_en'],
                $articles[$key]['slug_ar'],
                $articles[$key]['slug_en'],
                $articles[$key]['title_ar'],
                $articles[$key]['title_en'],
                $articles[$key]['short_desc_ar'],
                $articles[$key]['short_desc_en'],
                $articles[$key]['desc_ar'],
                $articles[$key]['desc_en'],
                $articles[$key]['created_at'],
                $articles[$key]['updated_at'],
            );
        }
        $data['data'] = ['success' => true, 'OurProgram' => $OurProgram, 'articles' => $articles];
        return response()->json($data, 200);
    }
}
