<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Project;

class ProjectsController extends Controller
{
    public function homepageProjects($lang = 'ar')
    {
        header('Access-Control-Allow-Origin: *');
        $projects = Project::select('id', 'name_' . $lang  . ' AS name_', 'project_photo', 'type_mobile', 'slug_' . $lang . ' AS slug')->orderBy('arrangement', 'desc')->take(7)->get();
        if (sizeof($projects) > 0) {
            $data['data'] = ['success' => true, 'projects' => $projects];
        } else {
            $data['data'] = ['success' => true, 'empty' => true];
        }

        return response()->json($data, 200);
    }

    public function allprojects($category_id, $lang = 'ar')
    {
        header('Access-Control-Allow-Origin: *');
        if ($category_id == 3) {
            $projects = Project::select('id', 'name_' . $lang  . ' AS name_', 'project_photo', 'type_mobile', 'slug_' . $lang . ' AS slug')->orderBy('arrangement', 'desc')->paginate(12);
        } else {
            $projects = Project::where('type_mobile', $category_id)->select('id', 'name_' . $lang  . ' AS name_', 'project_photo', 'type_mobile', 'slug_' . $lang . ' AS slug')->orderBy('arrangement', 'desc')->paginate(12);
        }
        if (sizeof($projects) > 0) {
            $data['data'] = ['success' => true, 'projects' => $projects];
        } else {
            $data['data'] = ['success' => true, 'empty' => true];
        }

        return response()->json($data, 200);
    }

    public function ViewProject($lang = 'ar', $slug = 1)
    {
        header('Access-Control-Allow-Origin: *');
        $project = Project::with('photo')->select('id', 'name_' . $lang . ' AS name', 'client_' . $lang . ' AS client', 'website_url', 'appstore_url', 'googleplay_url', 'description_' . $lang . ' AS description', 'cover_photo', 'project_date', 'type_mobile', 'slug_' . $lang . ' AS slug')->where('slug_ar', $slug)->orWhere('slug_en', $slug)->first();
        $project->previous = (Project::where('arrangement', '<', $project->id)->min('arrangement')) ? Project::find(Project::where('id', '<', $project->id)->max('id'))->{'slug_' . $lang} : null;
        $project->next = (Project::where('arrangement', '>', $project->id)->max('arrangement')) ?  Project::find(Project::where('id', '>', $project->id)->min('id'))->{'slug_' . $lang} : null;
        $webslider = [];
        $mobileslider = [];
        $mobilesliderNew = [];
        foreach ($project->photo as $key => $value) {
            if ($value->type_mobile == 0) {
                $webslider[$key]['photo'] = url('/images/projectsImages/' . $value->photo);
            } elseif ($value->type_mobile == 1) {
                $mobileslider[$key] = $value;
                if ($lang == 'ar') {
                    $name = $value->name_ar;
                    $description = $value->description_ar;
                } elseif ($lang == 'en') {
                    $name = $value->name_en;
                    $description = $value->description_en;
                }
                unset($mobileslider[$key]['name_ar'], $mobileslider[$key]['name_en'], $mobileslider[$key]['description_ar'], $mobileslider[$key]['description_en']);
                $mobileslider[$key]['name'] = $name;
                $mobileslider[$key]['description'] = $description;
                $mobileslider[$key]['photo'] = url('/images/projectsImages/' . $value->photo);
            }
        }
        $mobilesliderNew['background'] = url('/images/project/' . $project->id . '/cover_photo/' . $project->cover_photo);
        $mobilesliderNew['photos'] = array_values($webslider);

        $project->webslider =  $mobilesliderNew;
        if ($project->type_mobile == 1) {
            $project->mobileslider = array_values($mobileslider);
        }

        unset($project->photo);
        $data['data'] = ['success' => true, 'project' => $project];
        return response()->json($data, 200);
    }
}
