<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Branche;
use App\Page;
use App\FaqAdmin;
use App\SeoSetting;
use Illuminate\Support\Facades\App;

class StaticController extends Controller
{
    public function branches()
    {
        return Branche::get();
    }

    public function branche($id)
    {
        return Branche::find($id);
    }

    public function pages()
    {
        return Page::get();
    }

    public function page($id)
    {
        return Page::find($id);
    }

    public function faqs($lang = 'en')
    {
        header('Access-Control-Allow-Origin: *');
        $faq = FaqAdmin::where('active', true)->select('id', 'title_' . $lang . ' as title', 'desc_' . $lang . ' as desc')->paginate(10);
        $data['success'] = true;
        $data['data'] = $faq;
        return response()->json($data);
    }

    public function pageList($type, $lang = 'en')
    {
        header('Access-Control-Allow-Origin: *');
        $pages = Page::where('level', $type)->select('id', 'title_' . $lang . ' as title', 'slug_' . $lang . ' as slug')->get();
        $data['success'] = true;
        $data['data'] = $pages;
        return response()->json($data);
    }

    public function getPage($slug, $lang = 'en')
    {
        header('Access-Control-Allow-Origin: *');
        return Page::where('slug_' . $lang, $slug)->select('id', 'title_' . $lang . ' as title', 'slug_' . $lang . ' as slug','body_' . $lang . ' as body' , 'meta_desc_' . $lang . ' as meta_desc')->first();
    }

    public function faq($id)
    {
        return FaqAdmin::find($id);
    }

    public function getMeta($meta, $lang = 'en')
    {
        header('Access-Control-Allow-Origin: *');
        $seoSetting = SeoSetting::select(
            $meta . '_meta_title_' . $lang . ' AS meta_title',
            $meta . '_meta_keywords_' . $lang . ' AS meta_keywords',
            $meta . '_meta_description_' . $lang . ' AS meta_description',
            $meta . '_meta_image'
        )->find(1);
        $data['success'] = true;
        $data['data'] = $seoSetting;
        return response()->json($data);
    }
}
