<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Team;

class TeamsController extends Controller
{
    public function getTeam($lang = 'ar')
    {
        header('Access-Control-Allow-Origin: *');
        $team = Team::select('id','name_' .$lang . ' AS name','position_' .$lang . ' AS position','photo')->orderBy('created_at', 'desc')->get();
        if(sizeof($team) > 0){
            $data['data'] = ['success' => true, 'team' => $team];
        }else{
            $data['data'] = ['success' => true, 'empty' => true];
        }
        
        return response()->json($data, 200);
    }
}
