<?php

namespace App\Http\Controllers\API;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Support\Facades\Auth;
use Validator;



class UsersController extends Controller
{
    public $successStatus = 200;
    public function login(){
        //if (Auth::attempt(['email' => request('email'), 'password' => request('password')])) {
        if (Auth::attempt(['phone' => request('phone'), 'password' => request('password')])) {
            $user = Auth::user();
            if($user->active){
                $success['token'] = $user->createToken('MyApp')->accessToken;
                return response()->json(['success' => $success], $this->successStatus);
            }
            else{
                return response()->json(['error' => 'unactive user'], 401);
            }
            
        } else {
            return response()->json(['error' => 'Unauthorised'], 401);
        }
    }
    
    public function register(Request $request){
        $validator = Validator::make($request->all(), [
            'f_name'             => 'required',
            'l_name'             => 'required',
            //'phone'              => 'required|numeric|min:10|max:14|unique:users', 
            'phone'              => 'required|string|min:10|max:14|unique:users', 
            'email'              => 'required|email|unique:users',
            'address'            => 'required',
            'zip_code'           => 'required',
            'password'           => 'required|min:8',
            //'c_password'         => 'required|same:password',
            'type_id'            => 'required', //Individual OR Company
            'company'            => 'required', 
            'id_photo_forward'   => 'required|max:10000|mimes:jpg,jpeg,png',
            'id_photo_back'      => 'required|max:10000|mimes:jpg,jpeg,png',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 401);
        }

        $input = $request->all();
        //uploads
        if($request->file('id_photo_forward')){
            $file = $request->file('id_photo_forward');
            $name = time().$file->getClientOriginalName();
            $file->move('images',$name);
            $input['id_photo_forward'] = $name;
        }
        if($request->file('id_photo_back')){
            $file = $request->file('id_photo_back');
            $name = time().$file->getClientOriginalName();
            $file->move('images',$name);
            $input['id_photo_back'] = $name;
        }
        
        
        $input['password']  = bcrypt($input['password']);
        $input['npassword'] = $input['password'];
        $input['virification_code'] = $this->randomPassword(4);//generate code
        //$input['type'] = 'client';
        $user = User::create($input);
        $this->sendingcode($user);//sending user code
        $success['token'] = $user->createToken('MyApp')->accessToken;
        $success['name'] = $user->name;


        return response()->json(['success' => $success], $this->successStatus);
    }

    public function forgetpassword(Request $request){
        if($request->email){
            // check if mail is valid
            $user = User::where(['email'=>$request->email])->get();
            if(count($user)){
                $userData = $user[0];
                $userpassword = $this->randomPassword(12);
                //update user password
                $userData->password = bcrypt($userpassword);
                $userData->save();
                // sending mail to user with new password
                $data = array('name'=>$userData->f_name." ".$userData->l_name);
   
                Mail::send(['text'=>'mail'], $data, function($message) {
                    $message->to($userData->email, 'Password Recover')->subject
                        ('Your new Password is :'.$userpassword);
                    $message->from('info@gmail.com','Mazad Site owner');
                });

            }
            else{
                return response()->json(['error' => "Not Found"], 401);
            }
        }
    }
    public function updateprofile(Request $request){
        $user = AUth::user();
        $data = User::find($user->id);
        $validator = Validator::make($request->all(), [
            'f_name'             => 'required',
            'l_name'             => 'required',
            //'phone'              => 'required|numeric|min:10|max:14|unique:users', 
            //'phone'              => 'required|string|min:10|max:14|unique:users', 
            //'email'              => 'required|email|unique:users',
            'address'            => 'required',
            'zip_code'           => 'required',
            'password'           => 'min:8',
            //'c_password'         => 'required|same:password',
            'type_id'            => 'required', //Individual OR Company
            'company'            => 'required', 
            'id_photo_forward'   => 'max:10000|mimes:jpg,jpeg,png',
            'id_photo_back'      => 'max:10000|mimes:jpg,jpeg,png',
        ]);

        
        
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 401);
        }
        $input = $request->all();

        if($request->file('id_photo_forward')){
            $file = $request->file('id_photo_forward');
            $name = time().$file->getClientOriginalName();
            $file->move('images',$name);
            $input['id_photo_forward'] = $name;
        }
        else{
            $input['id_photo_forward'] = $user->id_photo_forward;
        }

        if($request->file('id_photo_back')){
            $file = $request->file('id_photo_back');
            $name = time().$file->getClientOriginalName();
            $file->move('images',$name);
            $input['id_photo_back'] = $name;
        }
        else{
            $input['id_photo_back'] = $user->id_photo_back;
        }        
        $user->email = $request->email;
        if($request->password){
            $user->password = bcrypt($request->password);
            $user->npassword = $request->password;
        }
        $user->f_name             = $request->f_name;
        $user->l_name             = $request->l_name;
        $user->address            = $request->address;
        $user->zip_code           = $request->zip_code;
        $user->type_id            = $request->type_id;
        $user->company            = $request->company;
        $user->id_photo_forward   = $input['id_photo_forward'];
        $user->id_photo_back      = $input['id_photo_back'];
        
        

        $newuser = $user->save();

        return response()->json(['user' => $newuser], $this->successStatus);
    }
    
    public function activateAccount(Request $request){ //using code
        $validator = Validator::make($request->all(), [
            'phone'              => 'required|string|min:10|max:14|unique:users', 
            'password'           => 'required|min:8',
            'virification_code'  => 'required|string|min:4|max:4'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 401);
        }
        $user = User::where(['phone'=>$request->phone,'password'=>bcrypt($request->password)])->get();
        if(count($user)){
            $userData = $user[0];
            if($requst->virification_code == $userData->virification_code){
                if($userData->active == true){
                    return response()->json(['error' => 'Account is aleady Active'], 401);
                }
                $userData->active = true;
                $userData->save();
                return response()->json(['success' => 'account is Active'], $this->successStatus);
            }
            else{
                return response()->json(['error' => 'Invalid Code'], 401);
            }
        }
        else{
            return response()->json(['error' => 'Wrong info'], 401);
        }
    }
    //forget password -resend code Sms - update user profile -updat…
    

    function sendingcode(Request $user){
        // sending user code
        $user = User::find($user->id);
    }

    function randomPassword($length) {
        $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
        $pass = array(); //remember to declare $pass as an array
        $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
        for ($i = 0; $i < $length; $i++) {
            $n = rand(0, $alphaLength);
            $pass[] = $alphabet[$n];
        }
        return implode($pass); //turn the array into a string
    }

    
}
