<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Branche;
use Illuminate\Support\Facades\Validator;

class BranchesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Branche::paginate(18);
        return view('admin.branches.view',['data'=>$data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.branches.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate([
            'title_ar'      => 'required',
            'title_en'      => 'required',
            'adress'        => 'required',
            'phone'         => 'required',
            'times_of_work' => 'required',
            'location_lat'  => 'required',
            'location_lon'  => 'required',
        ],
        [
            'title_ar.required'      => trans('Branches.title_ar_error'),
            'title_en.required'      => trans('Branches.title_en_error'),
            'adress.required'        => trans('Branches.adress_error'),
            'phone.required'         => trans('Branches.phone_error'),
            'times_of_work.required' => trans('Branches.times_of_work_error'),
            'location_lat.required'  => trans('Branches.location_lat_error'),
            'location_lon.required'  => trans('Branches.location_lon_error'),
        ]
    );

        Branche::create([
            'title_ar'      => $request->title_ar,
            'title_en'      => $request->title_en,
            'adress'        => $request->adress,
            'phone'         => $request->phone,
            'times_of_work' => $request->times_of_work,
            'location_lat'  => $request->location_lat,
            'location_lon'  => $request->location_lon,
        ]);

        return redirect('admin/branches');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Branche::find($id);

        return view('admin.branches.edit',['data'=>$data]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator =  $request->validate([
            'title_ar'      => 'required',
            'title_en'      => 'required',
            'adress'        => 'required',
            'phone'         => 'required',
            'times_of_work' => 'required',
            'location_lat'  => 'required',
            'location_lon'  => 'required',
        ],
        [
            'title_ar.required'      => trans('Branches.title_ar_error'),
            'title_en.required'      => trans('Branches.title_en_error'),
            'adress.required'        => trans('Branches.adress_error'),
            'phone.required'         => trans('Branches.phone_error'),
            'times_of_work.required' => trans('Branches.times_of_work_error'),
            'location_lat.required'  => trans('Branches.location_lat_error'),
            'location_lon.required'  => trans('Branches.location_lon_error'),
        ]
    );
        $data = Branche::find($id);    
        
        $data->title_ar      = $request->title_ar;
        $data->title_en      = $request->title_en;
        $data->adress        = $request->adress;
        $data->phone         = $request->phone;
        $data->times_of_work = $request->times_of_work;
        $data->location_lat  = $request->location_lat;
        $data->location_lon  = $request->location_lon;

        $data->save();

        return redirect('admin/branches');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Branche::find($id);

        $data->delete();

        return redirect('admin/branches');
    }
}
