<?php

namespace App\Http\Controllers\Admin;

use App\Client;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ClientsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $clients = Client::paginate(18);
        return view('admin.clients.view', ['data' => $clients]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.clients.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $validator =  $request->validate(
            [
                'name_ar' => 'required',
                'name_en' => 'required',
                'photo' => 'max:10000|mimes:jpg,jpeg,png'
            ],
            [
                'name_ar.required'    => trans('title ara required'),
                'name_en.required' => trans('title eng required'),
                'photo.required' => trans('Countries.image_error')
            ]
        );
        $input = $request->all();
        $file = $request->file('photo');
        $name = $file->getClientOriginalName();
        $saveArticle  = Client::create([
            'name_ar'   => $request->name_ar,
            'name_en' => $request->name_en,
            'photo' => $name
        ]);

        if ($request->file('photo')) {
            $file = $request->file('photo');
            $name = $file->getClientOriginalName();
            $file->move('images/client/' . $saveArticle->id . '/', $name);
            $input['photo'] = $name;
        }

        session()->flash('notif', __('General.added_successfully'));
        return redirect('admin/clients');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Client::find($id);
        $data->delete();
        session()->flash('notif',__('General.deleted_successfully'));
        return redirect('admin/clients');
    }
}
