<?php

namespace App\Http\Controllers\Admin;

use App\Comment;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CommentsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $comments = Comment::paginate(18);
        return view('admin.comments.view', ['data' => $comments]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.comments.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate(
            [
                'name'             => 'required',
                'position'            => 'required',
                'comment'           => 'required',
                'photo'      => 'required|max:10000|mimes:jpg,jpeg,png',

            ]
        );

        $input = $request->all();
        if ($request->file('photo')) {
            $input['photo'] = $request->file('photo')->getClientOriginalName();
        }

        $v = Comment::create([
            'name' => $request->name,
            'position' => $request->position,
            'comment' => $request->comment,
            'photo' => $input['photo']
        ]);

        if ($request->file('photo')) {
            $request->file('photo')->move('images/comment/' . $v->id . '/photo', $input['photo']);
        }

        session()->flash('notif', __('General.added_successfully'));

        return redirect('admin/comments');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = Comment::find($id);
        // return $data;
        return view('admin.comments.show', ['data' => $data]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $comments = Comment::find($id);
        return view('admin.comments.edit', [
            'data' => $comments
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // return  $request->all();
        $validator =  $request->validate(
            [
                'name'             => 'required',
                'position'            => 'required',
                'comment'           => 'required'
            ]
        );
        $data = Comment::find($id);
        $input = $request->all();
        if ($request->file('photo')) {
            $input['photo'] = $request->file('photo')->getClientOriginalName();
            $request->file('photo')->move('images/comment/' . $id . '/photo', $input['photo']);
        }else{
            $input['photo'] = $data->photo;
        }

        if (Comment::find($id)->update($input)) {
            session()->flash('notif', __('General.modified_successfully'));
            return redirect('admin/comments');
        } else {
            session()->flash('notif', __('General.error'));
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Comment::find($id);
        $data->delete();
        session()->flash('notif', __('General.deleted_successfully'));
        return redirect('admin/comments');
    }
}
