<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\FaqAdmin;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Validator;

class FaqController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $sort_search = null;
        $data = FaqAdmin::orderBy('created_at', 'desc');
        if ($request->has('search')) {
            $sort_search = $request->search;
            $data = $data->where('title_' . App::getLocale(), 'like', '%' . $sort_search . '%');
        }
        $data = $data->paginate(15);
        return view('admin.faq.view', compact('data', 'sort_search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        return view('admin.faq.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate(
            [
                'title_ar' => 'required',
                'desc_ar' => 'required',
                'title_en'   => 'required',
                'desc_en'   => 'required',
            ],
            [
                'title_ar.required' => trans('Faq.title_ar_error'),
                'desc_ar.required' => trans('Faq.desc_ar_error'),
                'title_en.required'   => trans('Faq.title_en_error'),
                'desc_en.required'   => trans('Faq.desc_en_error')
            ]
        );
        $request->active = ($request->active == 'on') ? true : false;
        FaqAdmin::create([
            'title_ar' => $request->title_ar,
            'desc_ar'   => $request->desc_ar,
            'title_en'   => $request->title_en,
            'desc_en'   => $request->desc_en,
            'active'   => $request->active,
        ]);


        return redirect('admin/faq');
    }
    public function updateStatus(Request $request)
    {
        $FaqAdmin = FaqAdmin::findOrFail($request->id);
        // return $request;
        $FaqAdmin->active = $request->active;
        if ($FaqAdmin->save()) {
            return 1;
        }
        return 0;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = FaqAdmin::find($id);

        return view('admin.faq.edit', ['data' => $data]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator =  $request->validate(
            [
                'title_ar' => 'required',
                'desc_ar' => 'required',
                'title_en'   => 'required',
                'desc_en'   => 'required',
            ],
            [
                'title_ar.required' => trans('Faq.title_ar_error'),
                'desc_ar.required' => trans('Faq.desc_ar_error'),
                'title_en.required'   => trans('Faq.title_en_error'),
                'desc_en.required'   => trans('Faq.desc_en_error')
            ]
        );
        $input = $request->all();
        $input['active'] = ($request->active == "on") ? true : false;
        if (FaqAdmin::find($id)->update($input)) {
            session()->flash('notif', __('General.modified_successfully'));
            return redirect()->route('faq.index');
        } else {
            session()->flash('notif', __('General.error'));
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        FaqAdmin::where('id', $id)->delete();
        session()->flash('notif', __('General.deleted_successfully'));
        return redirect()->route('faq.index');
    }
}
