<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\OurProgram;
use App\OurProgramAccordion;
use Illuminate\Support\Facades\App;

class OurProgramAccordions extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $lang =  App::getLocale();
        $ourPrograms = OurProgram::pluck('title_' . $lang, 'id');
        if (isset($_GET['id'])) {
            $programId = $_GET['id'];
        } else {
            $programId = null;
        }
        // return $ourPrograms;
        return view('admin.OurProgramAccordions.create', compact('ourPrograms', 'programId'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate(
            [
                'our_program_id' => 'required',
                'title_ar' => 'required',
                'title_en' => 'required',
                'description_ar' => 'required',
                'description_en' => 'required',
                'periority' => 'required',
            ]
        );

        OurProgramAccordion::create([
            'our_program_id'   => $request->our_program_id,
            'title_ar'   => $request->title_ar,
            'title_en' => $request->title_en,
            'description_ar' => $request->description_ar,
            'description_en' => $request->description_en,
            'periority' => $request->periority
        ]);

        session()->flash('notif', __('General.added_successfully'));
        return redirect('admin/OurPrograms/' . $request->our_program_id);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $lang =  App::getLocale();
        $ourPrograms = OurProgram::pluck('title_' . $lang, 'id');
        $OurProgramAccordions = OurProgramAccordion::find($id);
        return view('admin.OurProgramAccordions.edit', [
            'OurProgramAccordions' => $OurProgramAccordions,
            'ourPrograms' => $ourPrograms
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator =  $request->validate(
            [
                'our_program_id' => 'required',
                'title_ar' => 'required',
                'title_en' => 'required',
                'description_ar' => 'required',
                'description_en' => 'required',
                'periority' => 'required',
            ]
        );
        $input = $request->all();
        if (OurProgramAccordion::find($id)->update($input)) {
            session()->flash('notif', __('General.added_successfully'));
            return redirect('admin/OurPrograms/' . $request->our_program_id);
        } else {
            session()->flash('notif', __('General.error'));
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, $our_program_id)
    {
        // return $our_program_id;
        $data = OurProgramAccordion::find($id);
        $data->delete();
        session()->flash('notif', __('General.deleted_successfully'));
        return redirect('admin/OurPrograms/' . $our_program_id);
    }
}
