<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\OurProgram;
use App\OurProgramFeature;
use Illuminate\Support\Facades\App;

class OurProgramFeatures extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $lang =  App::getLocale();
        $ourPrograms = OurProgram::pluck('title_' . $lang, 'id');
        if (isset($_GET['id'])) {
            $programId = $_GET['id'];
        } else {
            $programId = null;
        }
        // return $ourPrograms;
        return view('admin.OurProgramFeatures.create', compact('ourPrograms', 'programId'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate(
            [
                'our_program_id' => 'required',
                'title_ar' => 'required',
                'title_en' => 'required',
                'periority' => 'required',
                'icon_w' => 'max:10000|mimes:jpg,jpeg,png,svg',
                'icon_o' => 'max:10000|mimes:jpg,jpeg,png,svg',
            ]
        );

        $icon_w = $request->file('icon_w');
        $icon_o = $request->file('icon_o');
        $icon_w_name = 'images/OurProgramFeatures/' . time() . '_' . $icon_w->getClientOriginalName();
        $icon_o_name = 'images/OurProgramFeatures/' . time() . '_' . $icon_o->getClientOriginalName();
        OurProgramFeature::create([
            'our_program_id'   => $request->our_program_id,
            'title_ar'   => $request->title_ar,
            'title_en' => $request->title_en,
            'periority' => $request->periority,
            'icon_w' => $icon_w_name,
            'icon_o' => $icon_o_name
        ]);

        if ($request->file('icon_w')) {
            $icon_w->move('images/OurProgramFeatures/', $icon_w_name);
        }

        if ($request->file('icon_o')) {
            $icon_o->move('images/OurProgramFeatures/', $icon_o_name);
        }

        session()->flash('notif', __('General.added_successfully'));
        return redirect('admin/OurPrograms/' . $request->our_program_id);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $lang =  App::getLocale();
        $ourPrograms = OurProgram::pluck('title_' . $lang, 'id');
        $OurProgramFeature = OurProgramFeature::find($id);
        return view('admin.OurProgramFeatures.edit', [
            'OurProgramFeature' => $OurProgramFeature,
            'ourPrograms' => $ourPrograms
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator =  $request->validate(
            [
                'our_program_id' => 'required',
                'title_ar' => 'required',
                'title_en' => 'required',
                'periority' => 'required',
            ]
        );
        $data = OurProgramFeature::find($id);
        $input = $request->all();
        if ($request->file('icon_w')) {
            $file = $request->file('icon_w');
            $name = 'images/OurProgramFeatures/' . time() . '_' . $file->getClientOriginalName();
            $file->move('images/OurProgramFeatures/', $name);
            $input['icon_w'] = $name;
        } else {
            $input['icon_w'] = $data->icon_w;
        }

        if ($request->file('icon_o')) {
            $file = $request->file('icon_o');
            $name = 'images/OurProgramFeatures/' . time() . '_' . $file->getClientOriginalName();
            $file->move('images/OurProgramFeatures/', $name);
            $input['icon_o'] = $name;
        } else {
            $input['icon_o'] = $data->icon_o;
        }
        if (OurProgramFeature::find($id)->update($input)) {
            session()->flash('notif', __('General.added_successfully'));
            return redirect('admin/OurPrograms/' . $request->our_program_id);
        } else {
            session()->flash('notif', __('General.error'));
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, $our_program_id)
    {
        // return $our_program_id;
        $data = OurProgramFeature::find($id);
        $data->delete();
        session()->flash('notif', __('General.deleted_successfully'));
        return redirect('admin/OurPrograms/' . $our_program_id);
    }
}
