<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\OurProgram;
use App\OurProgramModule;
use Illuminate\Support\Facades\App;

class OurProgramModules extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $lang =  App::getLocale();
        $ourPrograms = OurProgram::pluck('title_' . $lang, 'id');
        if (isset($_GET['id'])) {
            $programId = $_GET['id'];
        } else {
            $programId = null;
        }
        // return $ourPrograms;
        return view('admin.OurProgramModules.create', compact('ourPrograms', 'programId'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate(
            [
                'our_program_id' => 'required',
                'title_ar' => 'required',
                'title_en' => 'required',
                'description_ar' => 'required',
                'description_en' => 'required',
                'periority' => 'required',
                'icon_w' => 'max:10000|mimes:jpg,jpeg,png,svg',
                'icon_o' => 'max:10000|mimes:jpg,jpeg,png,svg',
            ]
        );

        $icon_w = $request->file('icon_w');
        $icon_o = $request->file('icon_o');
        $icon_w_name = 'images/OurProgramModules/' . time() . '_' . $icon_w->getClientOriginalName();
        $icon_o_name = 'images/OurProgramModules/' . time() . '_' . $icon_o->getClientOriginalName();
        OurProgramModule::create([
            'our_program_id'   => $request->our_program_id,
            'title_ar'   => $request->title_ar,
            'title_en' => $request->title_en,
            'description_ar' => $request->description_ar,
            'description_en' => $request->description_en,
            'periority' => $request->periority,
            'icon_w' => $icon_w_name,
            'icon_o' => $icon_o_name
        ]);

        if ($request->file('icon_w')) {
            $icon_w->move('images/OurProgramModules/', $icon_w_name);
        }

        if ($request->file('icon_o')) {
            $icon_o->move('images/OurProgramModules/', $icon_o_name);
        }

        session()->flash('notif', __('General.added_successfully'));
        return redirect('admin/OurPrograms/' . $request->our_program_id);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $lang =  App::getLocale();
        $ourPrograms = OurProgram::pluck('title_' . $lang, 'id');
        $OurProgramModule = OurProgramModule::find($id);
        return view('admin.OurProgramModules.edit', [
            'OurProgramModule' => $OurProgramModule,
            'ourPrograms' => $ourPrograms
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator =  $request->validate(
            [
                'our_program_id' => 'required',
                'title_ar' => 'required',
                'title_en' => 'required',
                'description_ar' => 'required',
                'description_en' => 'required',
                'periority' => 'required',
            ]
        );

        $data = OurProgramModule::find($id);
        $input = $request->all();
        if ($request->file('icon_w')) {
            $file = $request->file('icon_w');
            $name = 'images/OurProgramModules/' . time() . '_' . $file->getClientOriginalName();
            $file->move('images/OurProgramModules/', $name);
            $input['icon_w'] = $name;
        } else {
            $input['icon_w'] = $data->icon_w;
        }

        if ($request->file('icon_o')) {
            $file = $request->file('icon_o');
            $name = 'images/OurProgramModules/' . time() . '_' . $file->getClientOriginalName();
            $file->move('images/OurProgramModules/', $name);
            $input['icon_o'] = $name;
        } else {
            $input['icon_o'] = $data->icon_o;
        }
        if (OurProgramModule::find($id)->update($input)) {
            session()->flash('notif', __('General.added_successfully'));
            return redirect('admin/OurPrograms/' . $request->our_program_id);
        } else {
            session()->flash('notif', __('General.error'));
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, $our_program_id)
    {
        // return $our_program_id;
        $data = OurProgramModule::find($id);
        $data->delete();
        session()->flash('notif', __('General.deleted_successfully'));
        return redirect('admin/OurPrograms/' . $our_program_id);
    }
}
