<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\OurProgram;
use App\OurProgramSlider;
use Illuminate\Support\Facades\App;

class OurProgramSliders extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $lang =  App::getLocale();
        $ourPrograms = OurProgram::pluck('title_' . $lang, 'id');
        if (isset($_GET['id'])) {
            $programId = $_GET['id'];
        } else {
            $programId = null;
        }
        // return $ourPrograms;
        return view('admin.OurProgramSliders.create', compact('ourPrograms', 'programId'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate(
            [
                'our_program_id' => 'required',
                'title_ar' => 'required',
                'title_en' => 'required',
                'description_ar' => 'required',
                'description_en' => 'required',
                'periority' => 'required',
                'photo' => 'max:10000|mimes:jpg,jpeg,png',
            ]
        );

        $photo = $request->file('photo');
        $photo_name = 'images/OurProgramSliders/' . time() . '_' . $photo->getClientOriginalName();
        OurProgramSlider::create([
            'our_program_id'   => $request->our_program_id,
            'title_ar'   => $request->title_ar,
            'title_en' => $request->title_en,
            'description_ar' => $request->description_ar,
            'description_en' => $request->description_en,
            'periority' => $request->periority,
            'photo' => $photo_name
        ]);

        if ($request->file('photo')) {
            $photo->move('images/OurProgramSliders/', $photo_name);
        }

        session()->flash('notif', __('General.added_successfully'));
        return redirect('admin/OurPrograms/' . $request->our_program_id);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $lang =  App::getLocale();
        $ourPrograms = OurProgram::pluck('title_' . $lang, 'id');
        $OurProgramSlider = OurProgramSlider::find($id);
        return view('admin.OurProgramSliders.edit', [
            'OurProgramSlider' => $OurProgramSlider,
            'ourPrograms' => $ourPrograms
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator =  $request->validate(
            [
                'title_ar' => 'required',
                'title_en' => 'required',
                'description_ar' => 'required',
                'description_en' => 'required',
                'periority' => 'required',
                'our_program_id' => 'required'
            ]
        );
        $data = OurProgramSlider::find($id);
        $input = $request->all();
        if ($request->file('photo')) {
            $file = $request->file('photo');
            $name = 'images/OurProgramSliders/' . time() . '_' . $file->getClientOriginalName();
            $file->move('images/OurProgramSliders/', $name);
            $input['photo'] = $name;
        } else {
            $input['photo'] = $data->photo;
        }
        if (OurProgramSlider::find($id)->update($input)) {
            session()->flash('notif', __('General.added_successfully'));
            return redirect('admin/OurPrograms/' . $request->our_program_id);
        } else {
            session()->flash('notif', __('General.error'));
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id, $our_program_id)
    {
        // return $our_program_id;
        $data = OurProgramSlider::find($id);
        $data->delete();
        session()->flash('notif', __('General.deleted_successfully'));
        return redirect('admin/OurPrograms/' . $our_program_id);
    }
}
