<?php

namespace App\Http\Controllers\Admin;

use App\Article;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\OurProgram;
use Illuminate\Support\Facades\App;

class OurPrograms extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $OurPrograms = OurProgram::paginate(18);
        return view('admin.OurPrograms.view', ['OurPrograms' => $OurPrograms]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $articles = Article::pluck('title_' . App::getLocale(), 'id')->all();
        return view('admin.OurPrograms.create', compact('articles'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate(
            [
                'title_ar' => 'required',
                'title_en' => 'required',
                'slug_ar' => 'required',
                'slug_en' => 'required',
                'description_ar' => 'required',
                'description_en' => 'required',
                'periority' => 'required',
                'demo_link' => 'required',
                'photo' => 'max:10000|mimes:jpg,jpeg,png',
                'icon' => 'max:10000|mimes:jpg,jpeg,png'
            ]
        );

        $photo = $request->file('photo');
        $icon = $request->file('icon');
        $photo_name = 'images/OurPrograms/' . time() . '_' . $photo->getClientOriginalName();
        $icon_name = 'images/OurPrograms/' . time() . '_' . $icon->getClientOriginalName();
        $ourProgram = OurProgram::create([
            'title_ar'   => $request->title_ar,
            'title_en' => $request->title_en,
            'slug_ar' => $request->slug_ar,
            'slug_en' => $request->slug_en,
            'description_ar' => $request->description_ar,
            'description_en' => $request->description_en,
            'periority' => $request->periority,
            'demo_link' => $request->demo_link,
            'photo' => $photo_name,
            'icon' => $icon_name
        ]);
        $ourProgram->articles()->sync($request->articles);
        if ($request->file('photo')) {
            $photo->move('images/OurPrograms/', $photo_name);
        }

        if ($request->file('icon')) {
            $icon->move('images/OurPrograms/', $icon_name);
        }

        session()->flash('notif', __('General.added_successfully'));
        return redirect('admin/OurPrograms');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = OurProgram::with(['OurProgramSlider' => function ($ups) {
            $ups->orderBy('periority', 'ASC');
        }, 'OurProgramModule' => function ($opm) {
            $opm->orderBy('periority', 'ASC');
        }, 'OurProgramFeature' => function ($opf) {
            $opf->orderBy('periority', 'ASC');
        }, 'OurProgramAccordion' => function ($opa) {
            $opa->orderBy('periority', 'ASC');
        }])->find($id);
        // return $data->OurProgramModule;
        return view('admin.OurPrograms.show', ['data' => $data]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $OurPrograms = OurProgram::find($id);
        $articles = Article::pluck('title_' . App::getLocale(), 'id')->all();
        $OurProgramsarticles = $OurPrograms->articles->pluck('id', 'id')->all();
        return view('admin.OurPrograms.edit', [
            'OurPrograms' => $OurPrograms,
            'OurProgramsarticles' => $OurProgramsarticles,
            'articles' => $articles,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator =  $request->validate(
            [
                'title_ar' => 'required',
                'title_en' => 'required',
                'slug_ar' => 'required',
                'slug_en' => 'required',
                'description_ar' => 'required',
                'description_en' => 'required',
                'periority' => 'required',
                'demo_link' => 'required'
            ]
        );
        $data = OurProgram::find($id);
        $data->articles()->sync($request->articles);
        $input = $request->all();
        if ($request->file('photo')) {
            $file = $request->file('photo');
            $name = 'images/OurPrograms/' . time() . '_' . $file->getClientOriginalName();
            $file->move('images/OurPrograms/', $name);
            $input['photo'] = $name;
        } else {
            $input['photo'] = $data->photo;
        }

        if ($request->file('icon')) {
            $file = $request->file('icon');
            $name = 'images/OurPrograms/' . time() . '_' . $file->getClientOriginalName();
            $file->move('images/OurPrograms/', $name);
            $input['icon'] = $name;
        } else {
            $input['icon'] = $data->icon;
        }

        if (OurProgram::find($id)->update($input)) {
            session()->flash('notif', __('General.modified_successfully'));
            return redirect('admin/OurPrograms');
        } else {
            session()->flash('notif', __('General.error'));
        }
    }

    public function updateArrangement(Request $request, $id)
    {
        $data = OurProgram::find($id);
        $data->periority = $request->periority;
        $data->save();
        session()->flash('notif', __('General.modified_successfully'));
        return redirect('admin/OurPrograms');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = OurProgram::find($id);
        $data->delete();
        session()->flash('notif', __('General.deleted_successfully'));
        return redirect('admin/OurPrograms');
    }
}
