<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Page;
use Illuminate\Support\Facades\Validator;
class PagesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Page::paginate(18);
        return view('admin.pages.view',['data'=>$data]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        return view('admin.pages.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate(
            [
                'title_ar' => 'required',
                'title_en' => 'required',
                'body_ar'  => 'required',
                'body_en'  => 'required',
            ],
            [
                'title_ar.required' => trans('Pages.title_ar_error'),
                'title_en.required' => trans('Pages.title_en_error'),
                'body_ar.required'   => trans('Pages.body_ar_error'),
                'body_en.required'  => trans('Pages.body_en_error')
            ]
        );
        
        Page::create([
            'title_ar' =>$request->title_ar,
            'title_en' =>$request->title_en,
            'body_ar' =>$request->body_ar,
            'body_en' =>$request->body_en,
            'slug_ar' =>$request->slug_ar,
            'slug_en' =>$request->slug_en,
            'meta_desc_ar' =>$request->meta_desc_ar,
            'meta_desc_en' =>$request->meta_desc_en,
            'level' =>$request->level,
        ]);


        return redirect('admin/pages');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Page::find($id);

        return view('admin.pages.edit',['data'=>$data]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator =  $request->validate(
            [
                'title_ar' => 'required',
                'title_en' => 'required',
                'body_ar'  => 'required',
                'body_en'  => 'required',
            ],
            [
                'title_ar.required' => trans('Pages.title_ar_error'),
                'title_en.required' => trans('Pages.title_en_error'),
                'body_ar.requied'   => trans('Pages.body_ar_error'),
                'body_en.required'  => trans('Pages.body_en_error')
            ]
        );
        

        $data = Page::find($id);

        $data->title_ar  = $request->title_ar; 
        $data->title_en  = $request->title_en;
        $data->body_ar   = $request->body_ar;
        $data->body_en   = $request->body_en;
        $data->slug_ar   = $request->slug_ar;
        $data->slug_en   = $request->slug_en;
        $data->meta_desc_ar   = $request->meta_desc_ar;
        $data->meta_desc_en   = $request->meta_desc_en;
        $data->level   = $request->level;

        $data->save();

        return redirect('admin/pages');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Page::find($id);
        $data->delete();
        return redirect('admin/pages');
    }
}
