<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Project;
use App\ProjectPhoto;

class ProjectsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $projects = Project::paginate(18);
        return view('admin.projects.view', ['data' => $projects]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (session()->exists('files')) {
            session()->forget('files');
        }
        $projectType = trans('project.projectType');
        return view('admin.projects.add',['projectType' => $projectType]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //TODO Check Valid Date
        $validator =  $request->validate(
            [
                'slug_ar' => 'required',
                'slug_en' => 'required',
                'name_ar'            => 'required',
                'type_mobile'            => 'required',
                'name_en'             => 'required',
                'client_ar'            => 'required',
                'client_en'           => 'required',
                'description_ar'         => 'required',
                'description_en'         => 'required',
                'project_date'         => 'required',
                'cover_photo'    => 'required|max:10000|mimes:jpg,jpeg,png',

            ],
            [
                'type_mobile.required'            => trans('Vechicles.type_mobile_error'),
                'name_ar.required'            => trans('Vechicles.name_ar_error'),
                'name_en.required'             => trans('Vechicles.name_en_error'),
                'client_ar.required'            => trans('Vechicles.client_ar_error'),
                'client_en.required'           => trans('Vechicles.client_en_error'),
                'description_ar.required' => trans('Vechicles.description_ar_error'),
                'description_en.size'     => trans('Vechicles.description_en_error'),
                'project_date.integer'  => trans('Vechicles.project_date_error'),

            ]
        );

        
        $input = $request->all();
        if ($request->file('cover_photo')) {
            $input['cover_photo'] = $request->file('cover_photo')->getClientOriginalName();
        }

        if ($request->file('project_photo')) {
            $input['project_photo'] = $request->file('project_photo')->getClientOriginalName();
        }

       
        $v = Project::create([
            'type_mobile' => $request->type_mobile,
            'slug_ar' => $request->slug_ar,
            'slug_en' => $request->slug_en,
            'name_ar' => $request->name_ar,
            'name_en' => $request->name_en,
            'client_ar' => $request->client_ar,
            'client_en' => $request->client_en,
            'description_ar' => $request->description_ar,
            'project_date' => $request->project_date,
            'description_en' => $request->description_en,
            'cover_photo' => $input['cover_photo'],
            'project_photo' => $input['project_photo'],

        ]);

        if ($request->file('cover_photo')) {
            $request->file('cover_photo')->move('images/project/' . $v->id . '/cover_photo', $input['cover_photo']);
        }

        if ($request->file('project_photo')) {
            $request->file('project_photo')->move('images/project/' . $v->id . '/project_photo', $input['project_photo']);
        }


        //saving uploaded Images  
        if (session()->exists('files')) {

            for ($i = 0; $i < count(session()->get('files')); $i++) {
                ProjectPhoto::create(['project_id' => $v->id, 'photo' => session()->get('files')[$i]['file'], 'uuid' => session()->get('files')[$i]['id']]);
            }
            session()->forget('files');
        }
        // session()->flash('notif', __('General.added_successfully'));

        return redirect('admin/projectPhotos/' . $v->id);
    }

    public function projectPhotos($id)
    {
        $photos = ProjectPhoto::where('project_id', '=', $id)->get();
        $type = trans('project.type');
        // return $photos;
        return view('admin.projects.projectPhotos', ['photos' => $photos, 'type' => $type]);
    }
    public function editProjectPhotos(Request $request)
    {
        $data = $request->all();
        // return $data;
        for ($i = 0; $i < sizeof($request->name_ar); $i++) {
            $data = ProjectPhoto::find($request->id[$i]);
            $data->type_mobile = $request->type_mobile[$i];
            $data->name_ar = $request->name_ar[$i];
            $data->name_en = $request->name_en[$i];
            $data->description_ar = $request->description_ar[$i];
            $data->description_en = $request->description_en[$i];
             $data->arrangement = $request->arrangement[$i];
            $data->save();
        }
        return redirect('admin/projects');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = Project::with('photo')->find($id);
        // return $data;
        $type = trans('project.type');
        return view('admin.projects.show', ['data' => $data, 'type' => $type]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (session()->exists('files')) {
            session()->forget('files');
        }
        $projectType = trans('project.projectType');

        $projects = Project::find($id);
        return view('admin.projects.edit', [
            'data' => $projects,
            'projectType' => $projectType,
        ]);
    }
    
     public function updateArrangement(Request $request)
    {
        $data = Project::find($request->project_id);
        $data->arrangement  = $request->arrangement;
        $data->save();
        return redirect('admin/projects');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

         //TODO Check Valid Date
        $validator =  $request->validate(
            [
                'slug_ar' => 'required',
                'slug_en' => 'required',
                'type_mobile'            => 'required',
                'name_ar'            => 'required',
                'name_en'             => 'required',
                'client_ar'            => 'required',
                'client_en'           => 'required',
                'description_ar'         => 'required',
                'description_en'         => 'required',

            ],
            [
                'type_mobile.required'            => trans('Vechicles.type_mobile_error'),
                'name_ar.required'            => trans('Vechicles.name_ar_error'),
                'name_en.required'             => trans('Vechicles.name_en_error'),
                'client_ar.required'            => trans('Vechicles.client_ar_error'),
                'client_en.required'           => trans('Vechicles.client_en_error'),
                'description_ar.required' => trans('Vechicles.description_ar_error'),
                'description_en.size'     => trans('Vechicles.description_en_error'),

            ]
        );

        $data = Project::find($id);

        $input = $request->all();
        if ($request->file('cover_photo')) {
            $input['cover_photo'] = $request->file('cover_photo')->getClientOriginalName();
            $request->file('cover_photo')->move('images/project/' . $id . '/cover_photo', $input['cover_photo']);
        } else {
            $input['cover_photo'] = $data->cover_photo;
        }

        if ($request->file('project_photo')) {
            $input['project_photo'] = $request->file('project_photo')->getClientOriginalName();
            $request->file('project_photo')->move('images/project/' . $id . '/project_photo', $input['project_photo']);
        } else {
            $input['project_photo'] = $data->project_photo;
        } 
        $data->slug_ar             = $request->slug_ar;
        $data->slug_en             = $request->slug_en;
        $data->type_mobile             = $request->type_mobile;
        $data->website_url             = $request->website_url;
        $data->googleplay_url             = $request->googleplay_url;
        $data->appstore_url             = $request->appstore_url;
        $data->name_ar             = $request->name_ar;
        $data->name_en              = $request->name_en;
        $data->client_ar             = $request->client_ar;
        $data->client_en             = $request->client_en;
        $data->description_ar             = $request->description_ar;
        $data->project_date             = $request->project_date;
        $data->description_en             = $request->description_en;
        $data->client_ar             = $request->client_ar;
        $data->cover_photo       = $input['cover_photo'];
        $data->project_photo       = $input['project_photo'];

        $data->save();

        //saving uploaded Images  
        if (session()->exists('files')) {
            $prevPhotos = ProjectPhoto::where('project_id', $id)->get();
            $uuidArr =[];
            foreach($prevPhotos as $key => $value){
                $uuidArr[$key] = $value->uuid;
            }
            for ($i = 0; $i < count(session()->get('files')); $i++) {
                if(!in_array(session()->get('files')[$i]['id'],$uuidArr)){
                    ProjectPhoto::create(['project_id' => $id, 'photo' => session()->get('files')[$i]['file'], 'uuid' => session()->get('files')[$i]['id']]);
                }
            }
            session()->forget('files');
        }

        return redirect('admin/projectPhotos/' . $id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Project::find($id);
        $data->delete();
        session()->flash('notif', __('General.deleted_successfully'));
        return redirect('admin/projects');
    }

    public function imageuploads(Request $request)
    {
        $input = $request->all();
        if ($request->file('qqfile')) {
            $file = $request->file('qqfile');
            $name = time() . $file->getClientOriginalName(); //$request->qquuid;//time().$file->getClientOriginalName();
            $file->move('images/projectsImages', $name);
            $input['qqfile'] = $name;
            if (session()->exists('files')) {
                session()->push('files', ['file' => $name, 'id' => $request->qquuid]);
            } else {
                session(['files' => [['file' => $name, 'id' => $request->qquuid]]]);
            }
        }
        return  ["success" => true, "imageID" => $request->qquuid]; //{"success": true}';
    }

    public function getuploadedImages($id)
    {
        //$d[0] = ['name'=>'15623202131.jpg','uuid'=>'a6ce3c8d-6d41-4d9e-81d0-c3e460853797','thumbnailUrl'=>url('/images/15623202131.jpg')];
        $d = [];
        $data = ProjectPhoto::where('project_id', $id)->get();
        if (count($data)) {
            foreach ($data as $values) {

                $d[] = ['name' => $values->photo, 'uuid' => $values->uuid, 'thumbnailUrl' => url('/images/projectsImages/' . $values->photo)];

                if (session()->exists('files')) {
                    session()->push('files', ['file' => $values->photo, 'id' => $values->uuid]);
                } else {
                    session(['files' => [['file' => $values->photo, 'id' => $values->uuid]]]);
                }
            }
        }
        return $d;
    }

    public function imageuploadsdelete($id, Request $request)
    {
        $temp = [];
        if (session()->exists('files')) {
            $temp = session()->get('files');
            session()->forget('files');
            for ($i = 0; $i < count($temp); $i++) {
                if ($temp[$i]['id'] == $id) {
                    //session()->forget(session()->get('files')[$i]);
                    unset($temp[$i]);
                    continue;
                }
                if (!session()->exists('files')) {
                    session(['files' => [['file' => $temp[$i]['file'], 'id' => $temp[$i]['id']]]]);
                } else {
                    session()->push('files', ['file' => $temp[$i]['file'], 'id' => $temp[$i]['id']]);
                }
            }
            //session(['files'=>$temp]);
        }
        //check if image exits in database
        $image = ProjectPhoto::where('uuid', $id)->delete();

        return session()->get('files');
    }
}
