<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Team;

use function Ramsey\Uuid\v1;

class TeamsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $teams = Team::paginate(18);
        return view('admin.teams.view',['data' => $teams]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.teams.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate(
            [
                'name_ar' => 'required',
                'name_en' => 'required',
                'position_ar' => 'required',
                'position_en' => 'required',
                'photo' => 'max:10000|mimes:jpg,jpeg,png'
            ],
            [
                'name_ar.required'    => trans('name ara required'),
                'name_en.required' => trans('name eng required'),
                'position_ar.required' => trans('position eng required'),
                'position_en.required' => trans('position eng required'),
                'photo.required' => trans('Countries.image_error')
            ]
        );
        $input = $request->all();
        $file = $request->file('photo');
        $name = $file->getClientOriginalName();
        $saveTeam  = Team::create([
            'name_ar'   => $request->name_ar,
            'name_en' => $request->name_en,
            'position_ar' => $request->position_ar,
            'position_en' => $request->position_en,
            'photo' => $name
        ]);

        if ($request->file('photo')) {
            $file = $request->file('photo');
            $name = $file->getClientOriginalName();
            $file->move('images/team/' . $saveTeam->id . '/', $name);
            $input['photo'] = $name;
        }

        session()->flash('notif', __('General.added_successfully'));
        return redirect('admin/teams');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        
        $data = Team::find($id);
        $data->delete();
        session()->flash('notif',__('General.deleted_successfully'));
        return redirect('admin/teams');
    }
}
