<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Technology;

class TechnologiesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Technology::paginate(18);
        $type = trans('project.projectType');
        // return $type;
        return view('admin.technologies.view', ['data' => $data],compact('data','type'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $technologiesType = trans('project.projectType');
        return view('admin.technologies.add', compact('technologiesType'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate(
            [
                'name_ar' => 'required',
                'name_en' => 'required',
                'icon' => 'max:10000|mimes:jpg,jpeg,png'
            ],
            [
                'name_ar.required'    => trans('title ara required'),
                'name_en.required' => trans('title eng required'),
                'icon.required' => trans('Countries.image_error')
            ]
        );
        $file = $request->file('icon');
        $name = $file->getClientOriginalName();
        Technology::create([
            'name_ar'   => $request->name_ar,
            'type'   => $request->type,
            'name_en' => $request->name_en,
            'icon' => $name
        ]);

        if ($request->file('icon')) {
            $file = $request->file('icon');
            $name = $file->getClientOriginalName();
            $file->move('images/technology/', $name);
        }

        session()->flash('notif', __('General.added_successfully'));
        return redirect('admin/technologies');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $technologiesType = trans('project.projectType');
        $tech = Technology::find($id);
        return view('admin.technologies.edit', compact('technologiesType', 'tech'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator =  $request->validate(
            [
                'name_ar' => 'required',
                'name_en' => 'required'
            ]
        );
        $data = Technology::find($id);
        $input = $request->all();
        if ($request->file('icon')) {
            $file = $request->file('icon');
            $name =  $file->getClientOriginalName();
            $file->move('images/technology/', $name);
            $input['icon'] = $name;
        } else {
            $input['icon'] = $data->icon;
        }
        if (Technology::find($id)->update($input)) {
            session()->flash('notif', __('General.modified_successfully'));
            return redirect('admin/technologies');
        } else {
            session()->flash('notif', __('General.error'));
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Technology::find($id);
        $data->delete();
        session()->flash('notif', __('General.deleted_successfully'));
        return redirect('admin/technologies');
    }
}
