<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Role;
use App\User;
//use Validator;
use Illuminate\Support\Facades\Validator;

class UsersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
            'Role'=>['required'],
        ]);
    }

    public function index()
    {
        $users = User::with(['userrole'])->paginate(18);
        return view('admin.users.index',['data'=>$users]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $roles = Role::pluck('name','id');
        $type_id = trans('Users.user_type_id');
        $user_status = trans('Users.user_status');
        $user_language = trans('Users.user_language');
        return view('admin.users.add',[
            'roles'        =>$roles,
            'type_id'      =>$type_id,
            'user_status'  =>$user_status,
            'user_language'=>$user_language
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate([
            'name'             =>'required',
            'password'         =>'required|min:8',
            'email'            =>'required|email|unique:users',
            'phone'            =>'required|string|min:10|max:14|unique:users',    
            'role_id'          =>'required',
            'hasAdminAccess'   =>'required',
            'id_photo_forward' => 'required|max:10000|mimes:jpg,jpeg,png',
            'id_photo_back'    => 'required|max:10000|mimes:jpg,jpeg,png',
        ],
        [
            'name.required'             => trans('Users.name_error'),
            'password.required'         => trans('Users.password_error'),
            'email.required'            => trans('Users.email_error'),
            'role_id.required'          => trans('Users.role_id_error'),
            'hasAdminAccess.required'   => trans('Users.hasAdminAccess_error'),
            'id_photo_forward.required' => trans('Users.id_photo_forward_error'),
            'id_photo_back.required'    => trans('Users.id_photo_back_error'),
            'phone.required'            => trans('Users.phone_error'),
        ]
    );
        $input = $request->all();
        if($request->file('id_photo_forward')){
            $file = $request->file('id_photo_forward');
            $name = time().$file->getClientOriginalName();
            $file->move('images',$name);
            $input['id_photo_forward'] = $name;
        }
        if($request->file('id_photo_back')){
            $file = $request->file('id_photo_back');
            $name = time().$file->getClientOriginalName();
            $file->move('images',$name);
            $input['id_photo_back'] = $name;
        }

        
        $input['password'] = bcrypt($input['password']);
        $user              = User::create($input);
        $user->assignRole(Role::find($input['role_id'])->name);    
        return redirect('admin/users');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user  = User::find($id);

        $roles = Role::pluck('name','id');
        $type_id = trans('Users.user_type_id');
        $user_status = trans('Users.user_status');
        $user_language = trans('Users.user_language');
        return view('admin.users.edit',[
            'data'         =>$user,
            'roles'        =>$roles,
            'type_id'      =>$type_id,
            'user_status'  =>$user_status,
            'user_language'=>$user_language
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $validator =  $request->validate([
            'name'             => 'required',
            'password'         => 'min:8',
            'email'            => 'required|email|unique:users,email,'.$id,
            'phone'            => 'required|string|min:10|max:14|unique:users,phone,'.$id,
            'role_id'          => 'required',
            'hasAdminAccess'   => 'required',
            'id_photo_forward' => 'max:10000|mimes:jpg,jpeg,png',
            'id_photo_back'    => 'max:10000|mimes:jpg,jpeg,png',
        ],
        [
            'name.required'             => trans('Users.name_error'),
            'password.required'         => trans('Users.password_error'),
            'email.required'            => trans('Users.email_error'),
            'role_id.required'          => trans('Users.role_id_error'),
            'hasAdminAccess.required'   => trans('Users.hasAdminAccess_error'),
            'id_photo_forward.required' => trans('Users.id_photo_forward_error'),
            'id_photo_back.required'    => trans('Users.id_photo_back_error'),
            'phone.required'            => trans('Users.phone_error'),
        ]
    );
        $user = User::find($id);
        if($request->file('id_photo_forward')){
            $file = $request->file('id_photo_forward');
            $name = time().$file->getClientOriginalName();
            $file->move('images',$name);
            $input['id_photo_forward'] = $name;
        }
        else{
            $input['id_photo_forward'] = $user->id_photo_forward;
        }

        if($request->file('id_photo_back')){
            $file = $request->file('id_photo_back');
            $name = time().$file->getClientOriginalName();
            $file->move('images',$name);
            $input['id_photo_back'] = $name;
        }
        else{
            $input['id_photo_back'] = $user->id_photo_back;
        }



        //$user->removeRole('writer');
        
        $user->name = $request->name;
        $user->email = $request->email;
        if($request->password){
            $user->password = bcrypt($request->password);
        }
        
        $user->removeRole(Role::find($user->role_id)->name);
        $user->role_id            = $request->role_id;
        $user->hasAdminAccess     = $request->hasAdminAccess;
        $user->f_name             = $request->f_name;
        $user->l_name             = $request->l_name;
        $user->phone              = $request->phone;
        $user->address            = $request->address;
        $user->zip_code           = $request->zip_code;
        $user->type_id            = $request->type_id;
        $user->id_photo_forward   = $input['id_photo_forward'];
        $user->id_photo_back      = $input['id_photo_back'];
        $user->company            = $request->company;
        $user->individual_company = $request->individual_company;
        $user->active             = $request->active;
        $user->lang               = $request->lang;
        $user->balance_amount     = $request->balance_amount;

        $user->assignRole(Role::find($request->role_id)->name);    
        $user->save();
        return redirect('admin/users');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $user = User::find($id);
        $user->delete();
        return redirect('admin/users');
    }
}
