<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Article;
use App\OurProgram;
use Illuminate\Support\Facades\App;

class articlesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $articles = Article::paginate(18);
        return view('admin.articles.view', ['data' => $articles]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $article_type = trans('article.article_type');
        $ourprogramms = OurProgram::pluck('title_' . App::getLocale(), 'id')->all();
        return view('admin.articles.add', compact('article_type','ourprogramms'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate(
            [
                'title_ar' => 'required',
                'title_en' => 'required',
                'slug_ar' => 'required',
                'slug_en' => 'required',
                'short_desc_ar' => 'required',
                'hashtags_ar' => 'required',
                'hashtags_en' => 'required',
                'type' => 'required',
                'short_desc_en' => 'required'
            ],
            [
                'title_ar.required'    => trans('title ara required'),
                'title_en.required' => trans('title eng required'),
                'short_desc_en.required' => trans('short desc eng required'),
                'short_desc_ar.required' => trans('short desc ara required'),
            ]
        );
        $input = $request->all();
        $file = $request->file('photo');
        $name = $file->getClientOriginalName();
        $request->featured = ($request->featured == 'on') ? true : 'false';

        $saveArticle  = Article::create([
            'hashtags_ar'   => $request->hashtags_ar,
            'hashtags_en'   => $request->hashtags_en,
            'type'   => $request->type,
            'slug_ar'   => $request->slug_ar,
            'slug_en'   => $request->slug_en,
            'featured'   => $request->featured,
            'title_ar'   => $request->title_ar,
            'title_en' => $request->title_en,
            'short_desc_ar' => $request->short_desc_ar,
            'short_desc_en' => $request->short_desc_en,
            'desc_ar' => $request->desc_ar,
            'desc_en' => $request->desc_en,
            'article_date' => date('Y-m-d', strtotime($request->article_date)),
            'photo' => $name
        ]);
        $saveArticle->our_programms()->sync($request->ourprogramms);
        if ($request->file('photo')) {
            $file->move('images/article/' . $saveArticle->id, $name);
            $input['photo'] = $name;
        }

        session()->flash('notif', __('General.added_successfully'));
        return redirect('admin/articles');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = Article::find($id);
        return view('admin.articles.show', ['data' => $data]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $article_type = trans('article.article_type');
        $articles = Article::find($id);
        $ourprogramms = OurProgram::pluck('title_' . App::getLocale(), 'id')->all();
        $articlesourprogramms = $articles->our_programms->pluck('id', 'id')->all();
        return view('admin.articles.edit', [
            'data' => $articles,
            'article_type' => $article_type,
            'ourprogramms' => $ourprogramms,
            'articlesourprogramms' => $articlesourprogramms
            ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // return  $request->all();
        $validator =  $request->validate(
            [
                'title_ar' => 'required',
                'title_en' => 'required',
                'slug_ar' => 'required',
                'slug_en' => 'required',
                'short_desc_ar' => 'required',
                'short_desc_en' => 'required',
                'hashtags_ar' => 'required',
                'hashtags_en' => 'required',
                'type' => 'required',
                'photo' => 'max:10000|mimes:jpg,jpeg,png'
            ],
            [
                'title_ar.required'    => trans('title ara required'),
                'title_en.required' => trans('title eng required'),
                'short_desc_en.required' => trans('short desc eng required'),
                'short_desc_ar.required' => trans('short desc ara required'),
                'photo.required' => trans('Countries.image_error')
            ]
        );
        $data = Article::find($id);
        $data->our_programms()->sync($request->ourprogramms);
        $input = $request->all();
        $input['article_date'] = date('Y-m-d', strtotime($request->article_date));
        if ($request->file('photo')) {
            $file = $request->file('photo');
            $name = time() . $file->getClientOriginalName();
            $file->move('images/article/' . $id, $name);
            $input['photo'] = $name;
        } else {
            $input['photo'] = $data->photo;
        }
        $input['featured'] = ($request->featured == 'on') ? true : 'false';

        if (Article::find($id)->update($input)) {
            session()->flash('notif', __('General.modified_successfully'));
            return redirect('admin/articles');
        } else {
            session()->flash('notif', __('General.error'));
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Article::find($id);
        $data->delete();
        session()->flash('notif', __('General.deleted_successfully'));
        return redirect('admin/articles');
    }
}
