<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Product;

class productsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $products = Product::paginate(18);
        return view('admin.products.view', ['data' => $products]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.products.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate(
            [
                'name_ara' => 'required',
                'name_eng' => 'required',
                'type_ara' => 'required',
                'type_eng' => 'required',
                'photo' => 'max:10000|mimes:jpg,jpeg,png'
            ],
            [
                'name_ara.required'    => trans('name ara required'),
                'name_eng.required' => trans('name eng required'),
                'type_ara.required' => trans('type ara required'),
                'type_eng.required' => trans('type eng required'),
                'photo.required' => trans('Countries.image_error')
            ]
        );

        $input = $request->all();
        $file = $request->file('photo');
        $name = $file->getClientOriginalName();
        $saveProduct  = Product::create([
            'name_ara'   => $request->name_ara,
            'name_eng' => $request->name_eng,
            'type_ara' => $request->type_ara,
            'type_eng' => $request->type_eng,
            'photo' => $name
        ]);

        if ($request->file('photo')) {
            $file = $request->file('photo');
            $name = $file->getClientOriginalName();
            $file->move('images/product/' . $saveProduct->id . '/', $name);
            $input['photo'] = $name;
        }

        session()->flash('notif', __('General.added_successfully'));
        return redirect('admin/products');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
