<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Setting;

class settingsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $settings = Setting::find($id);
        return view('admin.settings.edit', ['data' => $settings]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = Setting::find($id);
        $input = $request->all();

        if ($request->file('cart_1_icon')) {
            $input['cart_1_icon'] = 'images/goals_card/' . $request->file('cart_1_icon')->getClientOriginalName();
            $request->file('cart_1_icon')->move('images/goals_card/', $request->file('cart_1_icon')->getClientOriginalName());
        } else {
            $input['cart_1_icon'] = $data->cart_1_icon;
        }

        if ($request->file('cart_2_icon')) {
            $input['cart_2_icon'] = 'images/goals_card/' . $request->file('cart_2_icon')->getClientOriginalName();
            $request->file('cart_2_icon')->move('images/goals_card/', $request->file('cart_2_icon')->getClientOriginalName());
        } else {
            $input['cart_2_icon'] = $data->cart_2_icon;
        }

        if ($request->file('cart_3_icon')) {
            $input['cart_3_icon'] = 'images/goals_card/' . $request->file('cart_3_icon')->getClientOriginalName();
            $request->file('cart_3_icon')->move('images/goals_card/', $request->file('cart_3_icon')->getClientOriginalName());
        } else {
            $input['cart_3_icon'] = $data->cart_3_icon;
        }

        if ($request->file('cart_4_icon')) {
            $input['cart_4_icon'] = 'images/goals_card/' . $request->file('cart_4_icon')->getClientOriginalName();
            $request->file('cart_4_icon')->move('images/goals_card/', $request->file('cart_4_icon')->getClientOriginalName());
        } else {
            $input['cart_4_icon'] = $data->cart_4_icon;
        }

        if (Setting::find($id)->update($input)) {
            session()->flash('notif', __('General.modified_successfully'));
            return redirect('admin/settings/1/edit');
        } else {
            session()->flash('notif', __('General.error'));
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
