<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Vehicle;

class vehiclesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $vehicles = Vehicle::paginate(18);
        return view('admin.vehicles.view', ['data' => $vehicles]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.vehicles.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate(
            [
                'title_ara' => 'required',
                'title_eng' => 'required',
                'photo' => 'max:10000|mimes:jpg,jpeg,png'
            ],
            [
                'title_ara.required'    => trans('title ara required'),
                'title_eng.required' => trans('title eng required'),
                'photo.required' => trans('Countries.image_error')
            ]
        );

        $input = $request->all();
        $file = $request->file('photo');
        $name = $file->getClientOriginalName();
        $saveVehicle  = Vehicle::create([
            'title_ara'   => $request->title_ara,
            'title_eng' => $request->title_eng,
            'photo' => $name
        ]);

        if ($request->file('photo')) {
            $file = $request->file('photo');
            $name = $file->getClientOriginalName();
            $file->move('images/vehicle/' . $saveVehicle->id . '/', $name);
            $input['photo'] = $name;
        }

        session()->flash('notif', __('General.added_successfully'));
        return redirect('admin/vehicles');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
