<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;
use App\Product;
use App\Vehicle;
use App\Clent;
use App\Article;
use App\Client;

class AdminIndexController extends Controller
{
    public function index(Request $request)
    {
        if (isset($_GET['lang'])) {
            if ($_GET['lang'] == 'ar') {
                $request->session()->put('language', 1);
                //$this->language = 1; 
                App::setLocale('ar');
            } else {
                $request->session()->put('language', 2);
                //$this->language = 1; 
                App::setLocale('en');
            }

            return redirect($_SERVER['HTTP_REFERER']);
        }
        $products = Product::count();
        $vehicles = Vehicle::count();
        $clients = Client::count();
        $articles = Article::count();
        return view('admin.index.index', ['products' => $products, 'vehicles' => $vehicles, 'clients' => $clients, 'articles' => $articles]);
    }
}
