<?php

namespace App\Http\Controllers;

use App\OfferPrice;
use Illuminate\Http\Request;

class OfferPriceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $sort_search = null;
        $offerPrices = OfferPrice::select(['offer_prices.*'])->orderBy('created_at', 'desc');
        if ($request->has('search')) {
            $sort_search = $request->search;
            $offerPrices = $offerPrices->where(function ($query) use ($sort_search) {
                $query->where('name', 'LIKE', '%' . $sort_search . '%')
                    ->orWhere('phone', 'LIKE', '%' . $sort_search . '%')
                    ->orWhere('email', 'LIKE', '%' . $sort_search . '%');
            });
        }
        $offerPrices = $offerPrices->paginate(15);
        return view('admin.OfferPrice.index', compact('offerPrices', 'sort_search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $OfferPrice = OfferPrice::findOrFail(decrypt($id));
        $OfferPrice->viewd = 1;
        $OfferPrice->save();
        return view('admin.OfferPrice.show', compact('OfferPrice'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
