<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Validator;


class RolesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $roles = Role::get();
        return view('admin.roles.index',['roles'=>$roles]);
        //return Role::get();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //return Route::currentRouteAction();
        /*foreach (Route::getRoutes()->getRoutes() as $route)
            {
                $action = $route->getAction();

                if (array_key_exists('controller', $action))
                {
                    // You can also use explode('@', $action['controller']); here
                    // to separate the class name from the method
                    $action['controller'] = \explode("\\",$action['controller']);
                    $controller = \explode("@",end($action['controller']));
                    $controllers[$controller[0]][] = $controller[1];
                    //$controllers[] = end($action['controller']);
                }
            }

            return $controllers;*/
        return view('admin.roles.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator =  $request->validate([
            'name' => 'required|unique:roles',
        ]);
        Role::create(['name'=>$request->name]);
        return redirect('admin/roles');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $role = Role::find($id);
        return view('admin.roles.edit',['role'=>$role]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator =  $request->validate([
            'name' => 'required|unique:roles,name,'.$id
        ]);
        $role = Role::find($id);

        return redirect('admin/roles');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $role = Role::find($id);
        $role->delete();
        // return redirect('admin/roles');
    }
}
