<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class OurProgram extends Model
{
    protected $fillable = [
        'title_ar',
        'title_en',
        'description_ar',
        'description_en',
        'photo',
        'icon',
        'periority',
        'demo_link',
        'slug_ar',
        'slug_en',
    ];

    public function OurProgramSlider()
    {
        return $this->hasMany('App\OurProgramSlider', 'our_program_id', 'id');
    }

    public function OurProgramModule()
    {
        return $this->hasMany('App\OurProgramModule', 'our_program_id', 'id');
    }

    public function OurProgramFeature()
    {
        return $this->hasMany('App\OurProgramFeature', 'our_program_id', 'id');
    }

    public function OurProgramAccordion()
    {
        return $this->hasMany('App\OurProgramAccordion', 'our_program_id', 'id');
    }

    public function articles()
    {
        return $this->belongsToMany(Article::class, 'our_program_articles');
    }
}
