<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    protected $fillable = [
        'type_mobile',
        'project_photo',
        'name_ar',
        'name_en',
        'client_ar',
        'client_en',
        'website_url',
        'appstore_url',
        'googleplay_url',
        'description_ar',
        'description_en',
        'cover_photo',
        'project_date',
        'arrangement',
        'slug_ar',
        'slug_en',
    ];

    public function photo()
    {
        return $this->hasMany('App\ProjectPhoto', 'project_id', 'id')->orderBy('arrangement');
    }
}
