<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;

use Spatie\Permission\Traits\HasRoles;

use Spatie\Permission\Models\Role;
use Laravel\Passport\HasApiTokens;
class User extends Authenticatable
{
    use Notifiable;
    use HasRoles;
    use HasApiTokens;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'npassword',
        'role_id',
        'hasAdminAccess',
        'f_name',
        'l_name',
        'phone',
        'address',
        'zip_code',
        'type_id',
        'id_photo_forward',
        'id_photo_back',
        'company',
        'individual_company',
        'auth_key',
        'device_token',
        'active',
        'virification_code',
        'lang',
        'balance_amount',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    
    public function userRole(){
        // model , index,primary
        return $this->belongsTo('App\Role','role_id','id');
    }
    
}
